import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    allCity: [],
    loading: false,
};

export const getCity = createAsyncThunk(
    "user/getCity",
    async ({ cityUrl, access_token }) => {
        const response = await queryResponse(cityUrl, "GET", access_token);
        return response;
    }
);

const getCitySlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetCity: (state) => {
            state.allCity = [];
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getCity.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getCity.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                let updateCity = [];
                for (let city of records?.data) {
                    updateCity.push(city);
                }
                state.allCity = updateCity;
            }
            state.loading = false;
        });
        builder.addCase(getCity.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { resetCity } = getCitySlice.actions;
export default getCitySlice.reducer;
